create or replace package tbicds.PCK_FX_SEC_PATIENT
AUTHID CURRENT_USER
is

/* Copyright 2015 Intellica Corporation 
Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at
    http://www.apache.org/licenses/LICENSE-2.0
Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
*/

 --custom to return recordsets
  type RetRefCursor is ref cursor;

   /* checks if a portal account exists for the patient */
   procedure CheckPatientFXUserRecRS( pi_vSessionID       in varchar2,
                                      pi_vSessionClientIP in varchar2,
                                      pi_nUserID          in number,
                                      pi_vKey             in varchar2,
                                      pi_vPatientID       in varchar2,
                                      po_nStatusCode      out number,
                                      po_vStatusComment   out varchar2,
                                      rs                  out RetRefCursor);

   /* gets a FXUserID given the patient */
   procedure GetPatientFXUserIdRS(pi_vSessionID       in varchar2,
                                  pi_vSessionClientIP in varchar2,
                                  pi_nUserID          in number,
                                  pi_vKey in varchar2,
                                  pi_vPatientID      in varchar2,
                                  po_nStatusCode      out number,
                                  po_vStatusComment   out varchar2,
                                  rs                  out RetRefCursor);

   /* gets the encrypted username/password pair for the patient */
   procedure GetPatientFXUsernamePasswordRS(pi_vSessionID       in varchar2,
                                            pi_vSessionClientIP in varchar2,
                                            pi_nUserID          in number,
                                            pi_vKey in varchar2,
                                            pi_vPatientID       in varchar2,
                                            po_nStatusCode      out number,
                                            po_vStatusComment   out varchar2,
                                            rs                  out RetRefCursor);

   /* updates the patient portal account */
   procedure InsertPatientFXUser (pi_vSessionID              in varchar2,
                                  pi_vSessionClientIP        in varchar2,
                                  pi_nUserID                 in number,
                                  pi_vKey in varchar2,
                                  pi_vPatientID              in varchar2,
                                  pi_vUserName               in varchar2,
                                  pi_vPassword               in varchar2,
                                  pi_nAccountLocked          in number,
                                  pi_nAccountInactive        in number,
                                  pi_vCOldPassword           in varchar2,
                                  pi_vCPassword              in varchar2,
                                  pi_vCUserName              in varchar2,   
                                  po_nFXUserID               out number,
                                  po_nStatusCode             out number,
                                  po_vStatusComment          out varchar2);

   /* updates the patient portal account password*/
   procedure UpdatePatientFXUserPWD(pi_vSessionID              in varchar2,
                                    pi_vSessionClientIP        in varchar2,
                                    pi_nUserID                 in number,
                                    pi_vKey in varchar2,
                                    pi_nFXUserID               in number,
                                    pi_vUserName               in varchar2,
                                    pi_vPassword               in varchar2,
                                    pi_nAccountLocked          in number,
                                    pi_nAccountInactive        in number,
                                    pi_vCPassword              in varchar2,
                                    pi_vCUserName              in varchar2,
                                    po_nStatusCode             out number,
                                    po_vStatusComment          out varchar2);
                  
   /* updates the patient portal account options */
   procedure UpdatePatientFXUserOptions(pi_vSessionID              in varchar2,
                                        pi_vSessionClientIP        in varchar2,
                                        pi_nUserID                 in number,
                                        pi_nFXUserID               in number,
                                        pi_nAccountLocked          in number,
                                        pi_nAccountInactive        in number,
                                        po_nStatusCode             out number,
                                        po_vStatusComment          out varchar2);


end;
/

